/**
 * @module       SmoothScroll
 * @author       Balazs Galambosi, Patrick Brunner, Michael Herf
 * @license      MIT license
 * @version      v0.9.9
 */
function ssc_init() {
    if (document.body) {
        var a = document.body, b = document.documentElement, c = window.innerHeight, d = a.scrollHeight;
        (ssc_root = 0 <= document.compatMode.indexOf("CSS") ? b : a, ssc_activeElement = a, ssc_initdone = !0, top != self) ? ssc_frame = !0 : d > c && (a.offsetHeight <= c || b.offsetHeight <= c) && (ssc_root.style.height = "auto", ssc_root.offsetHeight <= c) && (c = document.createElement("div"), c.style.clear = "both", a.appendChild(c));
        ssc_fixedback || (a.style.backgroundAttachment = "scroll", b.style.backgroundAttachment = "scroll");
        ssc_keyboardsupport && ssc_addEvent("keydown", ssc_keydown)
    }
}
function ssc_scrollArray(a, b, c, d) {
    if (d || (d = 1E3), ssc_directionCheck(b, c), ssc_que.push({
            x: b,
            y: c,
            lastX: 0 > b ? .99 : -.99,
            lastY: 0 > c ? .99 : -.99,
            start: +new Date
        }), !ssc_pending) {
        var e = function () {
            for (var n = +new Date, h = 0, m = 0, k = 0; k < ssc_que.length; k++) {
                var f = ssc_que[k], l = n - f.start, p = l >= ssc_animtime, g = p ? 1 : l / ssc_animtime;
                ssc_pulseAlgorithm && (g = ssc_pulse(g));
                l = f.x * g - f.lastX >> 0;
                g = f.y * g - f.lastY >> 0;
                h += l;
                m += g;
                f.lastX += l;
                f.lastY += g;
                p && (ssc_que.splice(k, 1), k--)
            }
            b && (n = a.scrollLeft, a.scrollLeft += h, h && a.scrollLeft === n && (b = 0));
            c && (h = a.scrollTop, a.scrollTop += m, m && a.scrollTop === h && (c = 0));
            b || c || (ssc_que = []);
            ssc_que.length ? setTimeout(e, d / ssc_framerate + 1) : ssc_pending = !1
        };
        setTimeout(e, 0);
        ssc_pending = !0
    }
}
function ssc_wheel(a) {
    ssc_initdone || ssc_init();
    var b = a.target, c = ssc_overflowingAncestor(b);
    if (!c || a.defaultPrevented || ssc_isNodeName(ssc_activeElement, "embed") || ssc_isNodeName(b, "embed") && /\.pdf/i.test(b.src))return !0;
    var b = a.wheelDeltaX || 0, d = a.wheelDeltaY || 0;
    b || d || (d = a.wheelDelta || 0);
    1.2 < Math.abs(b) && (b *= ssc_stepsize / 120);
    1.2 < Math.abs(d) && (d *= ssc_stepsize / 120);
    ssc_scrollArray(c, -b, -d);
    a.preventDefault()
}
function ssc_keydown(a) {
    var b = a.target, c = a.ctrlKey || a.altKey || a.metaKey;
    if (/input|textarea|embed/i.test(b.nodeName) || b.isContentEditable || a.defaultPrevented || c || ssc_isNodeName(b, "button") && a.keyCode === ssc_key.spacebar)return !0;
    var d;
    d = b = 0;
    var c = ssc_overflowingAncestor(ssc_activeElement), e = c.clientHeight;
    switch (c == document.body && (e = window.innerHeight), a.keyCode) {
        case ssc_key.up:
            d = -ssc_arrowscroll;
            break;
        case ssc_key.down:
            d = ssc_arrowscroll;
            break;
        case ssc_key.spacebar:
            d = a.shiftKey ? 1 : -1;
            d = -d * e * .9;
            break;
        case ssc_key.pageup:
            d = .9 * -e;
            break;
        case ssc_key.pagedown:
            d = .9 * e;
            break;
        case ssc_key.home:
            d = -c.scrollTop;
            break;
        case ssc_key.end:
            e = c.scrollHeight - c.scrollTop - e;
            d = 0 < e ? e + 10 : 0;
            break;
        case ssc_key.left:
            b = -ssc_arrowscroll;
            break;
        case ssc_key.right:
            b = ssc_arrowscroll;
            break;
        default:
            return !0
    }
    ssc_scrollArray(c, b, d);
    a.preventDefault()
}
function ssc_mousedown(a) {
    ssc_activeElement = a.target
}
function ssc_setCache(a, b) {
    for (var c = a.length; c--;)ssc_cache[ssc_uniqueID(a[c])] = b;
    return b
}
function ssc_overflowingAncestor(a) {
    var b = [], c = ssc_root.scrollHeight;
    do {
        var d = ssc_cache[ssc_uniqueID(a)];
        if (d)return ssc_setCache(b, d);
        if (b.push(a), c === a.scrollHeight) {
            if (!ssc_frame || ssc_root.clientHeight + 10 < c)return ssc_setCache(b, document.body)
        } else if (a.clientHeight + 10 < a.scrollHeight && (overflow = getComputedStyle(a, "").getPropertyValue("overflow"), "scroll" === overflow || "auto" === overflow))return ssc_setCache(b, a)
    } while (a = a.parentNode)
}
function ssc_addEvent(a, b, c) {
    window.addEventListener(a, b, c || !1)
}
function ssc_removeEvent(a, b, c) {
    window.removeEventListener(a, b, c || !1)
}
function ssc_isNodeName(a, b) {
    return a.nodeName.toLowerCase() === b.toLowerCase()
}
function ssc_directionCheck(a, b) {
    a = 0 < a ? 1 : -1;
    b = 0 < b ? 1 : -1;
    (ssc_direction.x !== a || ssc_direction.y !== b) && (ssc_direction.x = a, ssc_direction.y = b, ssc_que = [])
}
function ssc_pulse_(a) {
    var b, c, d;
    return a *= ssc_pulseScale, 1 > a ? b = a - (1 - Math.exp(-a)) : (c = Math.exp(-1), --a, d = 1 - Math.exp(-a), b = c + d * (1 - c)), b * ssc_pulseNormalize
}
function ssc_pulse(a) {
    return 1 <= a ? 1 : 0 >= a ? 0 : (1 == ssc_pulseNormalize && (ssc_pulseNormalize /= ssc_pulse_(1)), ssc_pulse_(a))
}
if (-1 === navigator.platform.toUpperCase().indexOf("MAC") && !navigator.userAgent.match(/(Android|iPod|iPhone|iPad|IEMobile|Opera Mini|BlackBerry)/)) {
    var ssc_framerate = 150, ssc_animtime = 700, ssc_stepsize = 100, ssc_pulseAlgorithm = !0, ssc_pulseScale = 8, ssc_pulseNormalize = 1, ssc_keyboardsupport = !0, ssc_arrowscroll = 50, ssc_frame = !1, ssc_direction = {
        x: 0,
        y: 0
    }, ssc_initdone = !1, ssc_fixedback = !0, ssc_root = document.documentElement, ssc_activeElement, ssc_key = {
        left: 37, up: 38, right: 39, down: 40, spacebar: 32, pageup: 33, pagedown: 34, end: 35,
        home: 36
    }, ssc_que = [], ssc_pending = !1, ssc_cache = {};
    setInterval(function () {
        ssc_cache = {}
    }, 1E4);
    var ssc_uniqueID = function () {
        var a = 0;
        return function (b) {
            return b.ssc_uniqueID || (b.ssc_uniqueID = a++)
        }
    }(), ischrome = /chrome/.test(navigator.userAgent.toLowerCase());
    ischrome && (ssc_addEvent("mousedown", ssc_mousedown), ssc_addEvent("mousewheel", ssc_wheel), ssc_addEvent("load", ssc_init))
}
;
