console.log("Quiz Loaded");
const HDQ = {
	EL: {
		quizzes: document.getElementsByClassName("hdq_quiz"),
		results: document.getElementsByClassName("hdq_results_wrapper")[0],
		questions: document.getElementsByClassName("hdq_question"),
		next: document.getElementsByClassName("hdq_next"),
		finish: document.getElementsByClassName("hdq_finsh_button"),
		answers: document.getElementsByClassName("hdq_option"),
		loading: document.getElementsByClassName("hdq_loading_bar")[0],
		// jPaginate: document.getElementsByClassName("hdq_jPaginate_button"),
	},
	VARS: {},
	init: async function () {
		console.log("HD Quiz Init");
		if (HDQ.EL.quizzes.length > 1) {
			for (let i = 0; i < HDQ.EL.quizzes.length; i++) {
				let html = `<p>HD QUIZ - WARNING: There is more than one quiz on this page. Due to the complexity of HD Quiz, only one quiz should on a page at a time.</p>`;
				HDQ.EL.quizzes[i].insertAdjacentHTML("beforebegin", html);
			}
		}

		// when an answer has been made
		for (let i = 0; i < HDQ.EL.answers.length; i++) {
			HDQ.EL.answers[i].addEventListener("change", HDQ.validate.check);
		}

		// when finish button selected
		for (let i = 0; i < HDQ.EL.finish.length; i++) {
			HDQ.EL.finish[i].addEventListener("click", function () {
				HDQ.submit(this);
			});
		}
		let init_actions = HDQ.VARS.init_actions;
		if (typeof init_actions != "undefined" && init_actions != null) {
			for (let i = 0; i < init_actions.length; i++) {
				if (typeof window[init_actions[i]] === "function") {
					await window[init_actions[i]]();
				}
			}
		}
	},
	validate: {
		all: async function () {
			for (let i = 0; i < HDQ.EL.answers.length; i++) {
				let t = await HDQ.validate.type(HDQ.EL.answers[i]);
				if (t != "") {
					let result = await HDQ.validate[t](HDQ.EL.answers[i]);
				}
			}
		},
		check: async function () {
			let t = await HDQ.validate.type(this);
			if (t != "" && t != "radio_multi") {
				if (HDQ.VARS.show_results_now === "yes" && HDQ.VARS.show_results === "yes") {
					let result = await HDQ.validate[t](this);
					HDQ.validate.extraText(result, this);
				}

				if (HDQ.VARS.stop_reselect === "yes") {
					await HDQ.validate.disable(this);
				} else {
					await HDQ.validate.checkToRadio(this);
				}
			} else {
				if (HDQ.VARS.show_results_now === "yes" && HDQ.VARS.show_results === "yes") {
					let result = await HDQ.validate[t](this, false);
					// HDQ.validate.extraText(result, this); // i just don't see a good way to do this
				}
			}
		},
		type: async function (el) {
			let t = el.getAttribute("data-type");
			if (t) {
				return t;
			} else {
				return "";
			}
		},
		checkToRadio(el) {
			let questionId = el.getAttribute("data-id");
			let question = document.getElementById("hdq_question_" + questionId);
			let answers = question.querySelectorAll(".hdq_option");
			for (let i = 0; i < answers.length; i++) {
				if (answers[i] != el) {
					answers[i].checked = false;
				}
				if (el.getAttribute('value') == "1") {
					// alert(true);
					el.parentNode.parentNode.parentNode.classList.add("hdq_correct");
					answers[i].disabled = true;
				} else {
					el.parentNode.parentNode.parentNode.classList.add("hdq_wrong");
                    $("#hdq_question_" + questionId).find(".hdq_option[value='1']").parents(".hdq_label_answer").addClass("hdq_correct");
					answers[i].disabled = true;
				};
			}
            $(".next-q").removeClass("disabled");
		},
		extraText: async function (result, el) {
			if (HDQ.VARS.show_extra_text == "yes") {
				await showExtraText(el);
			} else {
				if (!result) {
					await showExtraText(el);
				}
			}

			async function showExtraText(el) {
				let question = el.getAttribute("data-id");
				question = document.getElementById("hdq_question_" + question);
				let extra_text = question.querySelector(".hdq_question_after_text");
				if (extra_text != null) {
					extra_text.style.display = "block";
				}
			}
		},
		radio: async function (el) {
			let correct = false;
			let row = el.parentNode.parentNode.parentNode.parentNode;
			if (el.value == 1) {
				if (el.checked == true) {
					correct = true;
					if (HDQ.VARS.show_results == "yes") {
						row.classList.add("hdq_correct");
					}
				}
			} else {
				if (el.checked == true) {
					if (HDQ.VARS.show_results == "yes") {
						row.classList.add("hdq_wrong");
					}
				}
			}

			let question = el.getAttribute("data-id");
			question = document.getElementById("hdq_question_" + question);
			let answers = question.querySelectorAll(".hdq_option");
			for (let i = 0; i < answers.length; i++) {
				if (HDQ.VARS.mark_correct === "yes") {
					if (answers[i].value == 1) {
						row = answers[i].parentNode.parentNode.parentNode;
						row.classList.add("hdq_correct_not_selected");
					}
				}
				answers[i].disabled = true;
			}
			return correct;
		},

	},
	getResult: {
		multiple_choice_text: async function (answers) {
			for (let i = 0; i < answers.length; i++) {
				if (answers[i].checked == true) {
					let result = await HDQ.validate.radio(answers[i]);
					if (result) {
						HDQ.validate.extraText(true, answers[0]);
						return 1;
					}
				}
			}
			HDQ.validate.extraText(false, answers[0]);
			return 0;
		},
	},
	calculateScore: async function () {
		let total_score = 0;
		let total_questions = 0;
		let cs = document.getElementById("hdq_current_score");
		let tq = document.getElementById("hdq_total_questions");
		if (cs != null && tq != null) {
			total_score = parseInt(cs.value);
			total_questions = parseInt(tq.value);
		}
		total_questions += parseInt(HDQ.EL.questions.length);

		for (let i = 0; i < HDQ.EL.questions.length; i++) {
			let t = HDQ.EL.questions[i].getAttribute("data-type");
			let answers = HDQ.EL.questions[i].querySelectorAll(".hdq_option");
			if (answers.length > 0) {
				total_score += await HDQ.getResult[t](answers);
			} else {
				total_questions -= 1;
			}
		}

		HDQ.VARS.hdq_score = [parseInt(total_score), parseInt(total_questions)];
		// alert(HDQ.VARS.hdq_score);
		return HDQ.VARS.hdq_score;
	},
	submit: async function (el) {
		if (el === null || typeof el.getAttribute("id") === "undfined") {
			el = document.getElementsByClassName("hdq_finsh_button")[0];
		}

		if (el.classList.contains("hdq_complete")) {
			return;
		}

		HDQ.VARS.timer.active = false;

		// start visual feedback
		let quiz_ID = el.getAttribute("data-id");
		el.innerHTML = "...";
		el.classList.add("hdq_complete");
		jQuery(el).fadeOut("slow");
		//HDQ.EL.loading.classList.add("hdq_animate");

		// hide all buttons
		jQuery(".hdq_jPaginate_button").fadeOut();

		// show all questions in case of jPagination
        $(".hdq_question.active").removeClass("active");

		// validate all answers
		await HDQ.validate.all();
		// figure out the score
		let score = await HDQ.calculateScore();
		let data = "Your score was " + score[0] + " out of " + score[1];

		// update results section
		if (jQuery(".hdq_results_inner .hdq_result .hdq_result_percent")[0]) {
			let hdq_results_percent = (parseFloat(HDQ.VARS.hdq_score[0]) / parseFloat(HDQ.VARS.hdq_score[1])) * 100;
			// alert(hdq_results_percent);
			hdq_results_percent = Math.ceil(hdq_results_percent);
			data =
				'<span class = "hdq_result_fraction">' +
				data +
				'</span> - <span class = "hdq_result_percent">' +
				hdq_results_percent +
				"%</span>";
		}
		jQuery(".hdq_results_inner .hdq_result").html(data);

		let pass_percent = 0;
		pass_percent = score[0] / score[1];
		pass_percent = pass_percent * 100;
		/*if (pass_percent >= HDQ.VARS.pass_percent) {
			jQuery(".hdq_result_pass_great").show();
		}*/
		if (pass_percent >= 75) {
			jQuery(".hdq_result_pass_well").show();
		} else {
			jQuery(".hdq_result_fail").show();
		}
		$(".hdq_try_button").show();

		if (HDQ.VARS.share_results === "yes") {
			HDQ.share();
		}
		jQuery(".hdq_results_wrapper").fadeIn();
		$(".hdq_next_test_button:not(.hide-test)").show();

		if (typeof HDQ.VARS.submit_actions != undefined && HDQ.VARS.submit_actions != null) {
			for (let i = 0; i < HDQ.VARS.submit_actions.length; i++) {
				await HDQ.submitAction(HDQ.VARS.submit_actions[i]);
			}
		}

		if (HDQ.VARS.hide_questions === "yes") {
			jQuery(".hdq_question").fadeOut();
		}

		setTimeout(function () {
			HDQ.scroll();
		}, 1000);
	},
	submitAction: async function (action) {
		console.log("onSumbit action: " + action);
		let data = {};
		// if this is also a JS function, store data
		if (typeof window[action] !== "undefined") {
			let extra = {};
			data[action] = await window[action]();
			data.extra = data[action]; // for legacy
		}
		// small delay since this isn't syncronous
		setTimeout(function () {
			data.quizID = HDQ.VARS.id;
			data.score = HDQ.VARS.hdq_score;
			// send data to admin-ajax
			jQuery.ajax({
				type: "POST",
				data: {
					action: action,
					data: data,
				},
				url: HDQ.VARS.ajax,
				success: function (res) {
					console.log(res);
				},
			});
		}, 100);
	},
	share: function () {
		function create_twitter_share() {
			let baseURL = "https://twitter.com/intent/tweet?screen_name=";
			let shareText = HDQ.VARS.hdq_score[0] + "/" + HDQ.VARS.hdq_score[1] + " on the " + HDQ.VARS.name + " quiz. Can you beat me? ";
			shareText = encodeURI(shareText);
			let shareLink = baseURL + HDQ.VARS.twitter + "&text=" + shareText + encodeURI(HDQ.VARS.permalink);
			jQuery(".hdq_twitter").attr("href", shareLink);
		}
		create_twitter_share();
	},
	get_quiz_parent_container: async function (element, includeHidden) {
		var style = getComputedStyle(element);
		var excludeStaticParent = style.position === "absolute";
		var overflowRegex = includeHidden ? /(auto|scroll|hidden)/ : /(auto|scroll)/;

		if (style.position === "fixed") return document.body;
		for (var parent = element; (parent = parent.parentElement);) {
			style = getComputedStyle(parent);
			if (excludeStaticParent && style.position === "static") {
				continue;
			}
			if (overflowRegex.test(style.overflow + style.overflowY + style.overflowX)) return parent;
		}
		return document.body;
	},
	scroll_legacy: {
		results: function () {
			// this is super not accurate, but covers most themes.
			setTimeout(async function () {
				let hdq_quiz_container = document.querySelector("#hdq_" + HDQ.VARS.id);
				hdq_quiz_container = jQuery(await HDQ.get_quiz_parent_container(hdq_quiz_container));

				if (hdq_quiz_container[0].tagName === "DIV") {
					hdq_top =
						jQuery(hdq_quiz_container).scrollTop() +
						jQuery(".hdq_results_wrapper").offset().top -
						jQuery(".hdq_results_wrapper").height() / 2 -
						100;
					jQuery(hdq_quiz_container).animate(
						{
							scrollTop: hdq_top,
						},
						550
					);
					jQuery("html,body").animate(
						{
							scrollTop: hdq_top,
						},
						550
					);
				} else {
					let overflowH = jQuery("html").css("overflow");
					let overflowB = jQuery("body").css("overflow");
					let rest = false;
					if (overflowH.indexOf("hidden") >= 0 || overflowB.indexOf("hidden") >= 0) {
						rest = true;
					}

					jQuery("html,body").css("overflow", "initial");

					jQuery("html,body").animate(
						{
							scrollTop: jQuery(".hdq_results_wrapper").offset().top - 100,
						},
						550
					);

					if (rest) {
						setTimeout(function () {
							jQuery("html").css("overflow", overflowH);
							jQuery("body").css("overflow", overflowB);
						}, 550);
					}
				}
			}, 50);
		},
		question: function () {
			setTimeout(async function () {
				let hdq_quiz_container = document.querySelector("#hdq_" + HDQ.VARS.id);
				hdq_quiz_container = jQuery(await HDQ.get_quiz_parent_container(hdq_quiz_container));

				if (hdq_quiz_container[0].tagName === "DIV") {
					hdq_top =
						jQuery(hdq_quiz_container).scrollTop() +
						jQuery(".hdq_question:visible").offset().top -
						jQuery(".hdq_question:visible").height() / 2 -
						40;
					jQuery(hdq_quiz_container).animate(
						{
							scrollTop: hdq_top,
						},
						550
					);
				} else {
					let overflowH = jQuery("html").css("overflow");
					let overflowB = jQuery("body").css("overflow");
					let rest = false;
					if (overflowH.indexOf("hidden") >= 0 || overflowB.indexOf("hidden") >= 0) {
						rest = true;
					}

					jQuery("html,body").css("overflow", "initial");

					jQuery("html,body").animate(
						{
							scrollTop: jQuery(".hdq_question:visible").offset().top - 40,
						},
						550
					);

					if (rest) {
						setTimeout(function () {
							jQuery("html").css("overflow", overflowH);
							jQuery("body").css("overflow", overflowB);
						}, 550);
					}
				}
			}, 50);
		},
	},
	scroll: function () {
		const results_wrapper = document.getElementsByClassName("hdq_results_wrapper")[0];
		setTimeout(function () {
			results_wrapper.scrollIntoView({ behavior: "smooth", block: "start", inline: "nearest" });
		}, 300);
	},
	// gets find the parent question of an element
	getParent: async function (el) {
		let p = el.parentNode;
		if (p.classList.contains("hdq_question")) {
			return p;
		} else {
			p = HDQ.getParent(p);
		}
		return p;
	},
};

let hdq_locals = {};
if (typeof hdq_local_vars != "undefined") {
	hdq_locals = JSON.parse(hdq_local_vars);
	async function HDQ_INIT() {
		// set init vars
		async function hdqSetInitVars() {
			HDQ.VARS = {
				ajax: hdq_locals.hdq_ajax,
				featured_image: hdq_locals.hdq_featured_image,
				pass_percent: hdq_locals.hdq_pass_percent,
				id: hdq_locals.hdq_quiz_id,
				name: hdq_locals.hdq_quiz_name,
				permalink: hdq_locals.hdq_quiz_permalink,
				mark_correct: hdq_locals.hdq_results_correct,
				hide_questions: hdq_locals.hdq_hide_questions,
				share_results: hdq_locals.hdq_share_results,
				show_extra_text: hdq_locals.hdq_show_extra_text,
				show_results: hdq_locals.hdq_show_results,
				show_results_now: hdq_locals.hdq_show_results_now,
				stop_reselect: hdq_locals.hdq_stop_answer_reselect,
				submit_actions: hdq_locals.hdq_submit,
				init_actions: hdq_locals.hdq_init,
				timer: { time: hdq_locals.hdq_timer, max: hdq_locals.hdq_timer, question: hdq_locals.hdq_timer_question, active: false },
				twitter: hdq_locals.hdq_twitter_handle,
				ads: hdq_locals.hdq_use_ads,
				hdq_score: [],
				jPage: 0,
				paginate: false,
				legacy_scroll: hdq_locals.hdq_legacy_scroll,
			};
		}
		await hdqSetInitVars();
		HDQ.init();
	}
	HDQ_INIT();
}


jQuery("#hdq_fb_sharer").click(function () {
	let hdq_score = jQuery(".hdq_result").text();
	FB.ui(
		{
			method: "share",
			href: HDQ.VARS.permalink,
			hashtag: "#hdquiz",
			quote: "I scored " + hdq_score + " on the " + HDQ.VARS.name + " quiz. Can you beat me?",
		},
		function (res) { }
	);
});
