/**
 * plugin.js
 *
 * Released under LGPL License.
 * Copyright (c) 1999-2015 Ephox Corp. All rights reserved
 *
 * License: http://www.tinymce.com/license
 * Contributing: http://www.tinymce.com/contributing
 */

/*global tinymce:true */

tinymce.PluginManager.add('textpattern', function(editor) {
	var isPatternsDirty = true, patterns;

	patterns = editor.settings.textpattern_patterns || [
		{start: '*', end: '*', format: 'italic'},
		{start: '**', end: '**', format: 'bold'},
		{start: '#', format: 'h1'},
		{start: '##', format: 'h2'},
		{start: '###', format: 'h3'},
		{start: '####', format: 'h4'},
		{start: '#####', format: 'h5'},
		{start: '######', format: 'h6'},
		{start: '1. ', cmd: 'InsertOrderedList'},
		{start: '* ', cmd: 'InsertUnorderedList'},
		{start: '- ', cmd: 'InsertUnorderedList'}
	];

	// Returns a sorted patterns list, ordered descending by start length
	function getPatterns() {
		if (isPatternsDirty) {
			patterns.sort(function(a, b) {
				if (a.start.length > b.start.length) {
					return -1;
				}

				if (a.start.length < b.start.length) {
					return 1;
				}

				return 0;
			});

			isPatternsDirty = false;
		}

		return patterns;
	}

	// Finds a matching pattern to the specified text
	function findPattern(text) {
		var patterns = getPatterns();

		for (var i = 0; i < patterns.length; i++) {
			if (text.indexOf(patterns[i].start) !== 0) {
				continu